%------------------------------------------------------------------------------
% File     : SEU951^5 : TPTP v7.4.0. Released v4.0.0.
% Domain   : Set Theory (Functions)
% Problem  : TPS problem THM574
% Version  : Especial.
% English  : Challenge from Dana Scott stemming from injective Cantor Theorem.

% Refs     : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : tps_0577 [Bro09]
%          : THM574 [TPS]

% Status   : Theorem
% Rating   : 0.43 v7.4.0, 0.78 v7.2.0, 0.75 v7.1.0, 0.88 v7.0.0, 0.86 v6.4.0, 0.83 v6.3.0, 0.80 v6.2.0, 0.86 v5.5.0, 1.00 v4.0.0
% Syntax   : Number of formulae    :    4 (   0 unit;   3 type;   0 defn)
%            Number of atoms       :   12 (   3 equality;   7 variable)
%            Maximal formula depth :    7 (   4 average)
%            Number of connectives :    5 (   0   ~;   0   |;   0   &;   3   @)
%                                         (   0 <=>;   2  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    7 (   7   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    5 (   3   :;   0   =)
%            Number of variables   :    5 (   0 sgn;   3   !;   2   ?;   0   ^)
%                                         (   5   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : This problem is from the TPS library. Copyright (c) 2009 The TPS
%            project in the Department of Mathematical Sciences at Carnegie
%            Mellon University. Distributed under the Creative Commons copyleft
%            license: http://creativecommons.org/licenses/by-sa/3.0/
%          : Polymorphic definitions expanded.
%          : 
%------------------------------------------------------------------------------
thf(a_type,type,(
    a: $tType )).

thf(b_type,type,(
    b: $tType )).

thf(h,type,(
    h: ( a > $o ) > b )).

thf(cTHM574_pme,conjecture,
    ( ! [Xx: a > $o,Xy: a > $o] :
        ( ( ( h @ Xx )
          = ( h @ Xy ) )
       => ( Xx = Xy ) )
   => ? [Xg: b > a > $o] :
      ! [Y: a > $o] :
      ? [X: b] :
        ( ( Xg @ X )
        = Y ) )).

%------------------------------------------------------------------------------
